/*  Prüfung, ob eine Terminerung für eine gegebene ABK möglich ist.
    Bei Terminierbarkeit wird 0 ansonsten eine Bitmaske mit Gründen für die Nichtterminierbarkeit zurückgegeben.
*/
SELECT tsystem.function__drop_by_regex( 'abk__is_terminatable__info', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__is_terminatable__info(
    IN  _abk_ix int,
    IN _range_ab2_id_start int DEFAULT null, -- Übergebene ABK kann jetzt auf einen Bereich von AGen eingeschränkt werden. Bereichsbeginn.
    IN _range_ab2_id_end   int DEFAULT null, -- Übergebene ABK kann jetzt auf einen Bereich von AGen eingeschränkt werden. Bereichsende.
    IN _loglevel           int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' ),
    OUT errorcode bigint,
    OUT errormsg text
    )
    RETURNS record
    AS $$
    DECLARE
        _result record;
        _rec_ab2 ab2;
        _return bigint = 0;
        _returnmsg text;
        _ab2_a2_n_range int[];
    BEGIN
        -- Debug
        IF _loglevel >= 4 THEN
            RAISE NOTICE '%', format( 'call: scheduling.abk__is_terminatable__info( _abk_ix => %L, _range_ab2_id_start => %L, _range_ab2_id_end => %L, _loglevel => %L )',
                                                                                     _abk_ix      , _range_ab2_id_start      , _range_ab2_id_end     , _loglevel
                              )
            ;
        END IF;

        -- this function returns a bitmask
        -- currently the following states are implemented

        -- 0 => everything is fine
        -- & 1 => marked as done
        -- & 2 => no ab2 present
        -- & 4 => no ab2 with work present
        -- & 8 => ab2 with only ks_sperr present
        -- & 16 => abk does not exist

        IF NOT EXISTS( SELECT true FROM abk WHERE ab_ix = _abk_ix ) THEN
            _return := _return | 16;
            _returnmsg := format('error %s: abk %s does not exist', _return, _abk_ix);
            RAISE NOTICE '%', _returnmsg;

            errorcode := _return;
            errorMsg  := _returnmsg;

            RETURN;
        END IF;

        _ab2_a2_n_range := scheduling.abk__ab2__range_number__get( _abk_ix, _range_ab2_id_start, _range_ab2_id_end, false, false );

        SELECT
          ab_done,
          ab_inplantaf,
          count( a2_id ) AS ab2_count,
          count( a2_id ) FILTER (
            WHERE
                  not a2_ende
              AND scheduling.ab2__required_worktime__get( a2_id ) > 0
          ) AS ab2_work_count
        INTO _result
        FROM abk
        LEFT JOIN ab2 ON a2_ab_ix = ab_ix
                     AND a2_n >= _ab2_a2_n_range[1]
                     AND a2_n <= _ab2_a2_n_range[2]
        WHERE ab_ix = _abk_ix
        GROUP BY ab_ix;

        IF ( _result.ab_done ) THEN
            _return := _return | 1;
            _returnmsg := format('error %s: abk %s marked as done', _return, _abk_ix);
            RAISE NOTICE '%', _returnmsg;
        END IF;

        IF ( _result.ab2_count = 0 ) THEN
            _return := _return | 2;
            _returnmsg := format('error %s: abk %s contains no ab2', _return, _abk_ix);
            RAISE NOTICE '%', _returnmsg;
        END IF;

        IF ( _result.ab2_work_count = 0 ) THEN
            _return := _return | 4;
            _returnmsg := format('error %s: abk %s contains no ab2 with work', _return, _abk_ix);
            RAISE NOTICE '%', _returnmsg;
        END IF;

        FOR _rec_ab2 IN (
            SELECT *
              FROM ab2
             WHERE
                   a2_ende IS NOT true
               AND a2_ab_ix = _abk_ix
               AND scheduling.ab2__required_worktime__get( a2_id ) > 0
               AND a2_n >= _ab2_a2_n_range[1]
               AND a2_n <= _ab2_a2_n_range[2]
             ORDER BY a2_n
            )
        LOOP
            -- TODO AXS: Diesen Bereich ausbauen. An entsprechenden Codestellen extra scheduling.ab2__is_terminateable rufen. -> Ziel: Korrekte Fehlermeldung inkl. betroffene a2_n erhalten.
            IF NOT scheduling.ab2__is_terminateable( _rec_ab2, _loglevel => _loglevel )
            THEN
                _return := _return | 8;
                _returnmsg := format('error %s: abk %s contains ab2 %s with no non ks_sperr workplace ', _return, _abk_ix, _rec_ab2.a2_n);
                RAISE NOTICE '%', _returnmsg;
            END IF;
        END LOOP;

        errorcode := _return;
        errorMsg  := _returnmsg;

        RETURN;

    END $$ LANGUAGE plpgsql STABLE;

SELECT tsystem.function__drop_by_regex( 'abk__is_terminatable', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__is_terminatable(
    IN _abk_ix int,
    IN _range_ab2_id_start int DEFAULT null,
    IN _range_ab2_id_end   int DEFAULT null,
    IN _loglevel           int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
    )
    RETURNS bigint
    AS $$
       SELECT ( scheduling.abk__is_terminatable__info( _abk_ix, _range_ab2_id_start, _range_ab2_id_end, _loglevel => _loglevel ) ).errorcode;
    $$ LANGUAGE sql STABLE;